/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package viewer;

import java.awt.BorderLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;

import javax.swing.JFrame;

import com.inet.report.EngineRenderData;
import com.inet.viewer.RenderData;
import com.inet.viewer.SwingReportViewer;

/**
 * This sample demonstrates how you can change the logging stream of i-net Clear Reports viewer to any PrintStream,
 * including a FileOutputStream which is used in this example.
 */
public class LoggingToFile extends JFrame {

    private RenderData     renderConnection; // This is our main render data connection - the source of our raw report data coming from our report server
    private SwingReportViewer viewer;          // Our top-level viewer object

    /**
     * Change the logging stream of the Java viewer.
     */
    public LoggingToFile() {
        super( "i-net Clear Reports - Multiple Reports View" );
        // to initialize we first create a top level ReportViewer:
        viewer = new SwingReportViewer();

        // Here we now choose to change the logging output of the viewer:
        File f = new File( "C:/viewerlog.txt" );
        try( PrintStream ps = new PrintStream( new FileOutputStream( f ) ) ) {
            SwingReportViewer.setLoggingStream( ps );
        } catch( FileNotFoundException fnfe ) {
            // The log target could not be created. The logging will print to the console.
        }
        // Note that instead, we could supply any other PrintStream (we could also supply null in order
        // to deactivate log outputs completely)
        // SwingReportViewer.setLoggingStream( null );

        String reportLocation = "";
        try {
            reportLocation = getClass().getResource( "../sample.rpt" ).toURI().toString();
        } catch( URISyntaxException e ) {
            // Nothing to do
        }

        // then initialize the render data connection.
        renderConnection = new EngineRenderData( "report=" + reportLocation );

        // you will most likely have a report server already, so you can use the URL: http://server:port/report.rpt
        // renderConnection = new URLRenderData( "http://server:port/?report=file:c:/report1.rpt" );

        // addNewReportView causes a new report view to be created using the given connection as its data source, and then
        // for this newly created report to be added to the viewer.
        viewer.addNewReportView( renderConnection );

        // add the viewer to the target window
        getContentPane().add( BorderLayout.CENTER, viewer );

        pack();
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        (new LoggingToFile()).setVisible( true );
    }
}
